string GetDescription()
{
	return "This is a simple random harmony script.\n - Uses only chords from the triad\n - Either one chord per bar or two";
}

void GenerateHarmony(UniquePart @up)
{
	int chords = 6;
	
	int[][] map = { 
		
			{ 2,3,4,5,6 },
			{ 3,5 },
			{ 4,6 },
			{ 5,2,1 }, 
			{ 3,6,1 },
			{ 4,2 }
			
		};
		
	int reset = 4;
	if (RndInt(0,2) == 0) reset = 8;
	if (RndInt(0,2) == 0) reset = 2;
		
	ResetSeed();
	
	int cur_chord = 1;
	if (RndInt(0,3) == 0) cur_chord = RndInt(1,6);
	
	int r = 0;
	
	for (int i = 0; i < up.GetBars()-2; i++)
	{
		if (r == 0 || RndInt(0,2) != 0)
		{
			up.AddHarmonic(CreateTime(i,0), cur_chord, "135");
					
			if (RndInt(0,1) == 0)
			{
				if (RndInt(0,1) == 0)
				{
					up.AddHarmonic(CreateTime(i, RndInt(1,up.GetMetrum()-1)), cur_chord, "135"+RndInt(6,7));
					cur_chord = map[cur_chord-1][RndInt(0, map[cur_chord-1].length()-1)];
				}
				else
				{
					cur_chord = map[cur_chord-1][RndInt(0, map[cur_chord-1].length()-1)];
					up.AddHarmonic(CreateTime(i, RndInt(1,up.GetMetrum()-1)), cur_chord, "135");
					cur_chord = map[cur_chord-1][RndInt(0, map[cur_chord-1].length()-1)];	
				}
			}
			else cur_chord = map[cur_chord-1][RndInt(0, map[cur_chord-1].length()-1)];	
		}
		
		r++;
		if (r >= reset)
		{
			r = 0;
			ResetSeed();	
			cur_chord = 1;
			if (RndInt(0,3) == 0) cur_chord = RndInt(1,6);
		}
	}
	
	if (RndInt(0,1) == 0) up.AddHarmonic(CreateTime(up.GetBars()-2,0), 5, "135");
	else up.AddHarmonic(CreateTime(up.GetBars()-2,0), 5, "1357");
	
	up.AddHarmonic(CreateTime(up.GetBars()-1,0), 1, "135");

		
}